<?php
session_start();

// Verificação de sessão e permissões
if (!isset($_SESSION['usuario']) || !in_array(strtoupper($_SESSION['usuario']['perfil']), ['SUBDIRECÇÃO PEDAGÓGICA', 'ADMINISTRADOR'])) {
    header("Location: login.php");
    exit;
}

include 'conexao.php';

$perfil_gestor = strtoupper($_SESSION['usuario']['perfil']);

// --- Buscar professores ---
$professores = [];
$query_professores = "SELECT id, nome FROM usuarios WHERE perfil = 'PROFESSOR' ORDER BY nome ASC";
$result = $conn->query($query_professores);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $professores[] = $row;
    }
    $result->close();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Controlo de Históricos - SISMAG</title>
<link rel="stylesheet" href="css/inter/inter.css">
<script src="js/tailwindcss.js"></script>
<link rel="stylesheet" href="css/all.min.css">














<style>
    body { font-family: 'Inter', sans-serif; }
</style>
</head>
<body class="bg-gray-100 flex min-h-screen">

<!-- ===== BARRA LATERAL ===== -->
<aside class="w-60 bg-[#0d1b2a] text-white flex flex-col">
    <div class="p-4 text-center border-b border-gray-700">
        <h1 class="text-xl font-bold text-blue-400">SISMAG</h1>
        <p class="text-xs text-gray-400 mt-1"><?= $perfil_gestor ?></p>
    </div>

    <nav class="flex-1 mt-3">
        <a href="painel_gestor.php" class="block px-5 py-3 hover:bg-[#1b263b] transition">
            <i class="fas fa-home text-blue-400 mr-2"></i> Início
        </a>
        <a href="estatistica_turma.php" class="block px-5 py-3 hover:bg-[#1b263b] transition">
            <i class="fas fa-chart-bar text-blue-400 mr-2"></i> Estatísticas
        </a>
        <a href="historico_gestor.php" class="block px-5 py-3 bg-[#1b263b] transition">
            <i class="fas fa-list-ul text-blue-400 mr-2"></i> Histórico
        </a>
        <a href="logout.php" class="block px-5 py-3 hover:bg-red-700 transition">
            <i class="fas fa-sign-out-alt text-red-400 mr-2"></i> Sair
        </a>
    </nav>
</aside>

<!-- ===== CONTEÚDO PRINCIPAL ===== -->
<main class="flex-1 flex flex-col">
    <!-- Barra Superior -->
    <header class="bg-blue-700 text-white p-4 shadow flex justify-between items-center">
        <h2 class="text-lg font-semibold flex items-center gap-2">
            <i class="fas fa-list-ul text-white"></i> Controlo de Históricos (<?= $perfil_gestor ?>)
        </h2>
        <a href="painel_gestor.php" class="text-sm hover:text-gray-200 transition">
            <i class="fas fa-arrow-left"></i> Voltar
        </a>
    </header>

    <!-- Conteúdo -->
    <section class="flex-1 p-6">
        <div class="bg-white rounded-xl shadow-lg p-6 max-w-4xl mx-auto">
            <p class="text-gray-600 mb-6 border-b pb-3 text-sm">
                Selecione um professor para visualizar o seu histórico de lançamentos de notas.
            </p>

            <div class="overflow-x-auto">
                <?php if (empty($professores)): ?>
                    <div class="bg-yellow-100 border-l-4 border-yellow-500 text-yellow-800 p-4 rounded" role="alert">
                        <p class="font-bold">Nenhum professor encontrado</p>
                        <p>Não há usuários cadastrados com o perfil <b>PROFESSOR</b>.</p>
                    </div>
                <?php else: ?>
                    <ul class="divide-y divide-gray-200 border border-gray-200 rounded-lg">
                        <?php foreach ($professores as $professor): ?>
                            <li class="p-4 hover:bg-gray-50 transition duration-150">
                                <a href="historico_lancamentos.php?professor_id=<?= $professor['id'] ?>&nome_professor=<?= urlencode($professor['nome']) ?>"
                                   class="flex justify-between items-center text-gray-800 hover:text-blue-600 font-medium">
                                    <span class="flex items-center gap-2">
                                        <i class="fas fa-user-tie text-blue-500"></i>
                                        <?= htmlspecialchars($professor['nome']) ?>
                                    </span>
                                    <i class="fas fa-chevron-right text-sm text-gray-400"></i>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </section>
</main>

</body>
</html>
